/*
 * Decompiled with CFR 0.152.
 */
package dev.toma.gunsrpg.ai;

import dev.toma.gunsrpg.common.entity.ExplosiveSkeletonEntity;
import dev.toma.gunsrpg.common.init.ModItems;
import java.util.EnumSet;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.goal.Goal;

public class RangedAttackNoSightGoal
extends Goal {
    protected final ExplosiveSkeletonEntity entity;
    protected final double moveSpeedAmp;
    protected final float maxAttackDistance;
    protected int attackCooldown;
    private int attackTime = -1;
    private int seeTime;
    private boolean strafingClockwise;
    private boolean strafingBackwards;
    private int strafingTime = -1;

    public RangedAttackNoSightGoal(ExplosiveSkeletonEntity entity, double speedAmp, int attackCooldown, float maxAttackDistance) {
        this.entity = entity;
        this.moveSpeedAmp = speedAmp;
        this.attackCooldown = attackCooldown;
        this.maxAttackDistance = maxAttackDistance * maxAttackDistance;
        this.func_220684_a(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
    }

    public void setAttackCooldown(int attackCooldown) {
        this.attackCooldown = attackCooldown;
    }

    public void func_75249_e() {
        this.entity.func_213395_q(true);
        this.attackTime = 10;
    }

    public void func_75251_c() {
        this.entity.func_213395_q(false);
        this.seeTime = 0;
        this.attackTime = -1;
        this.entity.func_184602_cy();
    }

    public boolean func_75250_a() {
        return this.entity.func_70638_az() != null && this.isBowMainHand();
    }

    public boolean func_75253_b() {
        return (this.func_75250_a() || !this.entity.func_70661_as().func_75500_f()) && this.isBowMainHand();
    }

    protected boolean isBowMainHand() {
        return this.entity.func_233634_a_(item -> item == ModItems.GRENADE_LAUNCHER);
    }

    public void func_75246_d() {
        LivingEntity livingEntity = this.entity.func_70638_az();
        if (livingEntity != null) {
            boolean hasSeen;
            double distanceToTarget = this.entity.func_70092_e(livingEntity.func_226277_ct_(), livingEntity.func_226278_cu_(), livingEntity.func_226281_cx_());
            boolean canSee = this.entity.func_70635_at().func_75522_a((Entity)livingEntity);
            boolean bl = hasSeen = this.seeTime > 0;
            if (canSee != hasSeen) {
                this.seeTime = 0;
            }
            this.seeTime = canSee ? ++this.seeTime : --this.seeTime;
            if (distanceToTarget <= (double)this.maxAttackDistance && this.seeTime >= 20) {
                this.entity.func_70661_as().func_75499_g();
                ++this.strafingTime;
            } else {
                this.entity.func_70661_as().func_75497_a((Entity)livingEntity, this.moveSpeedAmp);
                this.strafingTime = -1;
            }
            if (this.strafingTime >= 20) {
                if ((double)this.entity.func_70681_au().nextFloat() < 0.3) {
                    boolean bl2 = this.strafingClockwise = !this.strafingClockwise;
                }
                if ((double)this.entity.func_70681_au().nextFloat() < 0.3) {
                    this.strafingBackwards = !this.strafingBackwards;
                }
                this.strafingTime = 0;
            }
            if (this.strafingTime > -1) {
                if (distanceToTarget > (double)(this.maxAttackDistance * 0.75f)) {
                    this.strafingBackwards = false;
                } else if (distanceToTarget < (double)(this.maxAttackDistance * 0.25f)) {
                    this.strafingBackwards = true;
                }
                this.entity.func_70605_aq().func_188488_a(this.strafingBackwards ? -0.5f : 0.5f, this.strafingClockwise ? 0.5f : -0.5f);
                this.entity.func_70625_a((Entity)livingEntity, 30.0f, 30.0f);
            } else {
                this.entity.func_70671_ap().func_75651_a((Entity)livingEntity, 30.0f, 30.0f);
            }
            if (canSee && distanceToTarget < (double)(this.maxAttackDistance * 2.0f)) {
                --this.attackTime;
                if (this.attackTime <= 0) {
                    this.entity.func_82196_d(livingEntity, 0.0f);
                    this.attackTime = this.attackCooldown;
                }
            }
        }
    }
}

